﻿using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class MapPatientSideApptRequestStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (state.ServiceAppointment.cvt_Type.Value)
                return;

            state.PatEcRequest = new MakeAppointmentMapper().MapMakeAppointmentRequest(state, Side.Patient);
            var siteNum = state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_loginSiteCode;
            state.PatLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy);
        }
    }
}
